/*---------------------------------------------------------------------------*\

    FILE....: threads.h
    TYPE....: C++ Include File
    AUTHOR..: David Rowe
    DATE....: 26/2/02

    This include file enables the VPB test programs to be compiled
    under Unix or Win32 using the same (unix) pthread function calls.

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#ifndef __THREADS__
#define __THREADS__

#ifdef WIN32

typedef struct {void *v; } pthread_mutex_t;	
typedef struct {void *v; } pthread_t;
void pthread_mutex_init(pthread_mutex_t *mutex, void *arg2);
void pthread_mutex_destroy(pthread_mutex_t *mutex);
void pthread_mutex_lock(pthread_mutex_t *mutex);
void pthread_mutex_unlock(pthread_mutex_t *mutex);
void pthread_create(pthread_t *athrd, void *arg2, void*(*func)(void*), void *data);

#else
#include <pthread.h>
#endif

#endif // __THREADS

